from typing import Optional
from pydantic import BaseModel

class UserCreate(BaseModel):
    fname: str
    lname: str
    email: str
    mobile: str
    password: str

class LoginSchema(BaseModel):
    email: str
    password: str

class UserResponse(BaseModel):
    id: int
    fname: str
    lname: str
    email: str
    mobile: str
    role: str
    is_approved: bool

    class Config:
        orm_mode = True

class UserUpdate(BaseModel):
    fname: Optional[str] = None
    lname: Optional[str] = None
    mobile: Optional[str] = None

class AdminCreate(BaseModel):
    fname: str
    lname: str
    email: str
    mobile: str
    password: str
    secret_key: str  # for secure access
